#!/usr/bin/env python3
# Test that the MESON_EXE_WRAPPER environment variable is set

import argparse
import os
import sys


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('binary')  # unused, but needed for test behavior
    parser.add_argument('--expected', action='store_true')
    args = parser.parse_args()

    defined = 'MESON_EXE_WRAPPER' in os.environ

    if args.expected != defined:
        print(os.environ, file=sys.stderr)
        return 1
    return 0


if __name__ == "__main__":
    sys.exit(main())
